/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.end.islands;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.FloatingIslandConfig;
import corgiaoc.byg.util.noise.fastnoise.lite.FastNoiseLite;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class FloatingIslands4
extends Feature<FloatingIslandConfig> {
    FastNoiseLite perlin = null;

    public FloatingIslands4(Codec<FloatingIslandConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, FloatingIslandConfig config) {
        double z;
        double y;
        double x;
        this.setSeed(world.func_72905_C());
        if (world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, pos.func_177958_n(), pos.func_177952_p()) > 4) {
            return false;
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        double radius = 11.0;
        double size = radius / 3.0;
        double radiusHalved = radius / 2.0;
        for (x = -radius - 5.0; x <= radius + 5.0; x += 1.0) {
            for (y = 1.0; y <= radius + 5.0; y += 1.0) {
                for (z = -radius - 5.0; z <= radius + 5.0; z += 1.0) {
                    mutable.func_189533_g((Vector3i)pos).func_196234_d((int)x, (int)y, (int)z);
                    double noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(mutable.func_177958_n(), mutable.func_177956_o(), mutable.func_177952_p()));
                    double distanceSqt1 = x * x + y * y + z * z + noise * noise;
                    if (!(distanceSqt1 <= radius * radius)) continue;
                    if (y == 1.0) {
                        world.func_180501_a((BlockPos)mutable, config.getTopBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                        continue;
                    }
                    world.func_180501_a((BlockPos)mutable, config.getBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        for (x = -radiusHalved; x <= radiusHalved; x += 1.0) {
            for (y = 2.0; y <= size; y += 1.0) {
                for (z = -radiusHalved; z <= radiusHalved; z += 1.0) {
                    mutable.func_189533_g((Vector3i)pos).func_196234_d((int)x, (int)y, (int)z);
                    double distanceSqt1 = x * x + y * y + z * z;
                    if (!(distanceSqt1 <= radiusHalved * radiusHalved)) continue;
                    world.func_180501_a((BlockPos)mutable, Blocks.field_150355_j.func_176223_P(), 2);
                    world.func_205219_F_().func_205360_a((BlockPos)mutable, (Object)Fluids.field_204546_a, 0);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

